
## ----- Shared -------------------------------------------------------------------

#version 130



## ----- Vertex -------------------------------------------------------------------

in vec4 position;

uniform vec4 Transform;

void main()
{
	vec2 pos = vec2(Transform.x + position.x * Transform.z, Transform.y + position.y * Transform.w);

	// Intentionally using a z-value of 0.5f
	gl_Position = vec4(pos, 0.5f, 1.0f);
}



## ----- Fragment -----------------------------------------------------------------

out vec4 FragColor;

uniform vec4 Color;

void main()
{
	FragColor = Color;
}



## ----- TECH ---------------------------------------------------------------------

technique Standard
{
	blendfunc = alpha;
	vs = Shared + Vertex;
	fs = Shared + Fragment;
	vertexattrib[0] = position;
}
