
## ----- Shared -------------------------------------------------------------------

#version 140		// Needed for isamplerBuffer

uniform ivec2 Size;
uniform int FirstPattern;



## ----- Vertex -------------------------------------------------------------------

in vec4 position;
out vec3 LocalOffset;

uniform ivec3 Position;		// With z = priority flag (0 or 1)
uniform ivec2 GameResolution;
uniform int WaterLevel;

void main()
{
	// Calculate local offset
	LocalOffset.x = position.x * float(Size.x * 8);
	LocalOffset.y = position.y * float(Size.y * 8);

	// Flip if necessary
	vec2 transformedVertex = position.xy;
	if ((FirstPattern & 0x0800) != 0)
		transformedVertex.x = (1.0f - transformedVertex.x);
	if ((FirstPattern & 0x1000) != 0)
		transformedVertex.y = (1.0f - transformedVertex.y);

	// Transform local -> screen space
	transformedVertex.x = float(Position.x) + transformedVertex.x * float(Size.x * 8);
	transformedVertex.y = float(Position.y) + transformedVertex.y * float(Size.y * 8);

	// Transform screen space -> view space
	gl_Position.x = transformedVertex.x / float(GameResolution.x) * 2.0f - 1.0f;
	gl_Position.y = transformedVertex.y / float(GameResolution.y) * 2.0f - 1.0f;
	gl_Position.z = float(Position.z) * 0.5f;
	gl_Position.w = 1.0f;

	// Calculate water offset
	LocalOffset.z = (transformedVertex.y - float(WaterLevel)) / float(GameResolution.y);
}



## ----- Fragment -----------------------------------------------------------------

in vec3 LocalOffset;
out vec4 FragColor;

uniform isamplerBuffer PatternCacheTexture;
uniform sampler2D PaletteTexture;
uniform vec4 TintColor;
uniform vec4 AddedColor;

void main()
{
	int ix = int(LocalOffset.x);
	int iy = int(LocalOffset.y);
	int patternX = ix / 8;
	int patternY = iy / 8;
	int localX = ix % 8;
	int localY = iy % 8;

	int patternIndex = FirstPattern + patternX * Size.y + patternY;
	int atex = (patternIndex >> 9) & 0x30;

	int patternCacheLookupIndex = localX + localY * 8 + (patternIndex & 0x07ff) * 256;
	int paletteIndex = atex + texelFetch(PatternCacheTexture, patternCacheLookupIndex).x;

	vec4 color = texture(PaletteTexture, vec2(float(paletteIndex) / 256.0f, LocalOffset.z + 0.5f));
	color = vec4(AddedColor.rgb, 0.0f) + color * TintColor;
	if (color.a < 0.01f)
		discard;

	FragColor = color;
}



## ----- TECH ---------------------------------------------------------------------

technique Standard
{
	blendfunc = alpha;
	vs = Shared + Vertex;
	fs = Shared + Fragment;
	vertexattrib[0] = position;
}
