
## ----- Shared -------------------------------------------------------------------

#version 140		// Needed for isamplerBuffer

uniform ivec2 Size;



## ----- Vertex -------------------------------------------------------------------

in vec4 position;
out vec3 LocalOffset;

uniform ivec3 Position;		// With z = priority flag (0 or 1)
uniform ivec2 PivotOffset;
uniform vec4 Transformation;
uniform ivec2 GameResolution;
uniform int WaterLevel;

void main()
{
	// Calculate local offset
	LocalOffset.x = position.x * float(Size.x);
	LocalOffset.y = position.y * float(Size.y);

	// Transform
	vec2 v = LocalOffset.xy + PivotOffset.xy;
	vec2 transformedVertex;
	transformedVertex.x = v.x * Transformation.x + v.y * Transformation.y;
	transformedVertex.y = v.x * Transformation.z + v.y * Transformation.w;

	// Transform local -> screen space
	transformedVertex.x = float(Position.x) + transformedVertex.x;
	transformedVertex.y = float(Position.y) + transformedVertex.y;

	// Transform screen space -> view space
	gl_Position.x = transformedVertex.x / float(GameResolution.x) * 2.0f - 1.0f;
	gl_Position.y = transformedVertex.y / float(GameResolution.y) * 2.0f - 1.0f;
	gl_Position.z = float(Position.z) * 0.5f;
	gl_Position.w = 1.0f;

	// Calculate water offset
	LocalOffset.z = (transformedVertex.y - float(WaterLevel)) / float(GameResolution.y);
}



## ----- Fragment -----------------------------------------------------------------

in vec3 LocalOffset;
out vec4 FragColor;

uniform isamplerBuffer SpriteTexture;
uniform sampler2D PaletteTexture;
uniform int Atex;
uniform vec4 TintColor;
uniform vec4 AddedColor;

void main()
{
	int ix = int(LocalOffset.x);
	int iy = int(LocalOffset.y);
	int paletteIndex = Atex + texelFetch(SpriteTexture, ix + iy * Size.x).x;

	vec4 color = texture(PaletteTexture, vec2(float(paletteIndex) / 256.0f, LocalOffset.z + 0.5f));
	color = vec4(AddedColor.rgb, 0.0f) + color * TintColor;
	if (color.a < 0.01f)
		discard;

	FragColor = color;
}



## ----- TECH ---------------------------------------------------------------------

technique Standard
{
	blendfunc = alpha;
	vs = Shared + Vertex;
	fs = Shared + Fragment;
	vertexattrib[0] = position;
}
